<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "../connect.php";
require "../lang.php";

$lang = get_current_language();
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    if (!isset($data['user_id'])) {
        echo json_encode([
            "status" => 400,
            "message" => trans()["user_id_required"][$lang]
        ]);
        exit;
    }

    if (!isset($data['user_reported_id'])) {
        echo json_encode([
            "status" => 400,
            "message" => trans()["user_reported_id_required"][$lang]
        ]);
        exit;
    }
    
    
    if (!isset($data['reason'])) {
        echo json_encode([
            "status" => 400,
            "message" => trans()["reason_required"][$lang]
        ]);
        exit;
    }

    $user_id = mysqli_real_escape_string($con, $data['user_id']);
    $user_reported_id = mysqli_real_escape_string($con, $data['user_reported_id']);
    $reason = isset($data['reason']) ? mysqli_real_escape_string($con, $data['reason']) : null;

    if ($user_id == $user_reported_id) {
        echo json_encode([
            "status" => 403,
            "message" => trans()["self_report_not_allowed"][$lang] ?? "You cannot report yourself."
        ]);
        exit;
    }

    $stmt = $con->prepare("INSERT INTO user_reports (user_id, user_reported_id, reason) VALUES (?, ?, ?)");
    $stmt->bind_param("iis", $user_id, $user_reported_id, $reason);

    if ($stmt->execute()) {
        
        // $countSql = "SELECT COUNT(*) as total_reports FROM user_reports WHERE user_reported_id = ?";
        // $countStmt = $con->prepare($countSql);
        // $countStmt->bind_param("i", $user_reported_id);
        // $countStmt->execute();
        // $countResult = $countStmt->get_result();
        // $countRow = $countResult->fetch_assoc();
        // $totalReports = $countRow['total_reports'];
    
        // if ($totalReports >= 10) {
        //     $banSql = "UPDATE users SET ban = 1 WHERE user_id = ?";
        //     $banStmt = $con->prepare($banSql);
        //     $banStmt->bind_param("i", $user_reported_id);
        //     $banStmt->execute();
        // }
    
        echo json_encode([
            "status" => 200,
            "message" => trans()["report_submitted"][$lang] ?? "Report submitted successfully."
        ]);
    } else {
        echo json_encode([
            "status" => 500,
            "message" => trans()["error_submitting_report"][$lang] ?? "Failed to submit report."
        ]);
    }
} else {
    echo json_encode([
        "status" => 405,
        "message" => trans()["method_not_allowed"][$lang] ?? "Method not allowed."
    ]);
    exit;
}
