<?php

require "../connect.php";
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');

// Polyfill for str_starts_with for PHP < 8
if (!function_exists('str_starts_with')) {
    function str_starts_with($haystack, $needle) {
        return $needle !== '' && strncmp($haystack, $needle, strlen($needle)) === 0;
    }
}

// Fallback helpers in case not defined in connect.php
if (!function_exists('error')) {
    function error($msg)
    {
        return json_encode([
            'status'  => 'error',
            'message' => $msg,
        ], JSON_UNESCAPED_UNICODE);
    }
}

if (!function_exists('success')) {
    function success($data)
    {
        return json_encode([
            'status'  => 'success',
            'message' => $data,
        ], JSON_UNESCAPED_UNICODE);
    }
}

$requestMethod = $_SERVER['REQUEST_METHOD'] ?? 'GET';

if ($requestMethod === "POST") {
    $res = productById();
    echo $res;
} else {
    http_response_code(405);
    echo json_encode([
        'status'  => 'error',
        'message' => 'Method not allowed. Only POST requests are accepted.'
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

function productById()
{
    global $con;

    $json  = file_get_contents('php://input');
    $obj   = json_decode($json, true);
    $headers = array_change_key_case(getallheaders(), CASE_LOWER);
    $lang    = strtolower(trim($headers['lang'] ?? ''));

    $product_id = mysqli_real_escape_string($con, $obj['product_id'] ?? '');
    $user_id    = mysqli_real_escape_string($con, $obj['user_id'] ?? '0');

    // Validate product_id
    if (empty($product_id)) {
        http_response_code(400);
        return error('product_id is required');
    }

    // Get product with joins
    $sql_select_item = mysqli_query($con, "
        SELECT products.*, categories.*
        FROM products 
        LEFT JOIN categories ON products.product_subCatId = categories.cat_id
        WHERE products.product_id = '$product_id'
        LIMIT 1
    ");
   
    if (!$sql_select_item || mysqli_num_rows($sql_select_item) != 1) {
        http_response_code(404);
        return error("Product not found");
    }

    $product = mysqli_fetch_object($sql_select_item);
    
    if ($product->hidden == 1) {
        http_response_code(404);
        return error("Product not found");
    }

    // Format basic product data
    $formatted_product = new stdClass();
    $formatted_product->product_id      = $product->product_id;
    $formatted_product->product_name    = $lang == 'en' ? $product->product_name_en : $product->product_name;
    $formatted_product->product_name_ar = $product->product_name;
    $formatted_product->product_name_en = $product->product_name_en;
        $formatted_product->product_colors = json_decode($product->product_colors);

    // Category info
    $formatted_product->category_name = $lang == 'en'
        ? ($product->cat_name_en ?? '')
        : ($product->cat_name ?? '');
    $formatted_product->category_id = $product->product_catId;
    
    // Description
    $formatted_product->description    = $lang == 'en' ? $product->product_description_en : $product->product_description;
    $formatted_product->description_ar = $product->product_description;
    $formatted_product->description_en = $product->product_description_en;
    
    // Pricing
    $formatted_product->price     = number_format($product->product_price, 2, '.', '');
    $formatted_product->old_price = number_format($product->product_price, 2, '.', '');
    $formatted_product->new_price = number_format($product->product_price - $product->product_discount, 2, '.', '');
    $formatted_product->discount_percentage = $product->product_price > 0 
        ? round(100 * ($product->product_discount / $product->product_price), 0) 
        : 0;
    
    // Rating and reviews summary (if exist in table)
    $formatted_product->rating        = isset($product->rating) ? floatval($product->rating) : 0;
    $formatted_product->reviews_count = isset($product->reviews_count) ? intval($product->reviews_count) : 0;
    $formatted_product->in_stock      = isset($product->in_stock) ? (bool)$product->in_stock : true;
    
    // User interactions - only check if valid user_id provided
    $has_valid_user = !empty(trim($user_id)) && trim($user_id) != "0";
    
    if ($has_valid_user) {
        // Check favorite
        $sql_favorite = mysqli_query($con, "
            SELECT * FROM favorites 
            WHERE favorite_userId = '$user_id' 
              AND favorite_productId = '$product_id'
        ");
        $formatted_product->is_favorite = $sql_favorite && mysqli_num_rows($sql_favorite) > 0;
        
        // Check cart
        $sql_cart = mysqli_query($con, "
            SELECT * FROM cart 
            WHERE item_userId = '$user_id' 
              AND item_productId = '$product_id'
        ");
        if ($sql_cart && mysqli_num_rows($sql_cart) > 0) {
            $cart_data = mysqli_fetch_object($sql_cart);
            $formatted_product->is_in_cart     = true;
            $formatted_product->item_id        = $cart_data->item_id;
            $formatted_product->item_quantity  = $cart_data->item_quantity;
        } else {
            $formatted_product->is_in_cart = false;
        }
    } else {
        $formatted_product->is_favorite = false;
        $formatted_product->is_in_cart  = false;
    }

    /* =======================
       Product images
       ======================= */
    $images = [];
    $sql_images = mysqli_query($con, "
        SELECT id, url 
        FROM product_images 
        WHERE product_id = '$product_id'
    ");
    if ($sql_images) {
        while ($row = mysqli_fetch_assoc($sql_images)) {
            $parts = explode('*arazon*', $row['url']);
            foreach ($parts as $singleUrl) {
                $url = trim($singleUrl);
                if ($url !== '') {
                    if (!str_starts_with($url, 'http')) {
                        $url = "https://api.tiffanyflowers.ae/admin/" . ltrim($url, '/');
                    }
                    $images[] = [
                        'id'  => intval($row['id']),
                        'url' => $url,
                    ];
                }
            }
        }
    }
    $formatted_product->images = $images;

    /* =======================
       Product properties/specifications
       ======================= */
    $properties = [];
    $sql_props = mysqli_query($con, "
        SELECT * 
        FROM product_props 
        WHERE product_id = '$product_id'
    ");
    if ($sql_props) {
        while ($prop = mysqli_fetch_assoc($sql_props)) {
            $properties[] = [
                'id'    => $prop['id']    ?? '',
                'name'  => $prop['title'] ?? '',
                'value' => $prop['value'] ?? '',
            ];
        }
    }
    $formatted_product->properties = $properties;

    /* =======================
       Category details
       ======================= */
    $cats_clean = preg_replace('/\s+/', '', $product->product_catId);
    $sql_cat = mysqli_query($con, "
        SELECT * 
        FROM categories 
        WHERE cat_id IN ('$cats_clean') 
        LIMIT 1
    ");
    if ($sql_cat && $cat_data = mysqli_fetch_assoc($sql_cat)) {
        $formatted_product->category = [
            'cat_id'   => $cat_data['cat_id'],
            'cat_name' => $lang == 'en'
                ? ($cat_data['cat_name_en'] ?? '')
                : ($cat_data['cat_name'] ?? ''),
            'cat_image' => $cat_data['cat_image'] ?? ''
        ];
    }

    /* =======================
       Related products
       ======================= */
    $related_products = [];
    $cats = mysqli_real_escape_string($con, trim($product->product_catId));
    
    $sql_related = mysqli_query($con, "
        SELECT * 
        FROM products 
        WHERE product_catId = '$cats' 
          AND hidden = '0' 
          AND product_id != '$product_id'
        LIMIT 8
    ");

    if ($sql_related) {
        while ($related = mysqli_fetch_object($sql_related)) {
            $related_item = [
                'id'              => $related->product_id,
                'product_name'    => $lang == 'en' ? $related->product_name_en : $related->product_name,
                'product_name_ar' => $related->product_name,
                'price'           => number_format($related->product_price, 2, '.', ''),
                'rating'          => isset($related->rating) ? floatval($related->rating) : 0,
                'reviews_count'   => isset($related->reviews_count) ? intval($related->reviews_count) : 0,
                'in_stock'        => isset($related->in_stock) ? (bool)$related->in_stock : true
            ];

            if ($related->product_discount > 0) {
                $related_item['old_price'] = number_format($related->product_price, 2, '.', '');
                $related_item['discount_percentage'] = round(
                    100 * ($related->product_discount / $related->product_price),
                    0
                );
            }

            // First image for related product
            $sql_img = mysqli_query($con, "
                SELECT url 
                FROM product_images 
                WHERE product_id = '$related->product_id' 
                LIMIT 1
            ");
            if ($sql_img && $img_data = mysqli_fetch_assoc($sql_img)) {
                $img_parts = explode('*arazon*', $img_data['url']);
                $img_url   = trim($img_parts[0] ?? '');
                if ($img_url !== '') {
                    if (!str_starts_with($img_url, 'http')) {
                        $img_url = "https://api.tiffanyflowers.ae/admin/" . ltrim($img_url, '/');
                    }
                    $related_item['image'] = $img_url;
                } else {
                    $related_item['image'] = '';
                }
            } else {
                $related_item['image'] = '';
            }

            // Check user interactions for related products
            if ($has_valid_user) {
                $sql_fav = mysqli_query($con, "
                    SELECT * 
                    FROM favorites 
                    WHERE favorite_userId = '$user_id' 
                      AND favorite_productId = '$related->product_id'
                ");
                $related_item['is_favorite'] = $sql_fav && mysqli_num_rows($sql_fav) > 0;
                
                $sql_crt = mysqli_query($con, "
                    SELECT * 
                    FROM cart 
                    WHERE item_userId = '$user_id' 
                      AND item_productId = '$related->product_id'
                ");
                $related_item['is_in_cart'] = $sql_crt && mysqli_num_rows($sql_crt) > 0;
            } else {
                $related_item['is_favorite'] = false;
                $related_item['is_in_cart']  = false;
            }

            $related_products[] = $related_item;
        }
    }
    $formatted_product->related_products = $related_products;

    /* =======================
       Reviews
       ======================= */
    $reviews = [];
    $sql_reviews = mysqli_query($con, "
        SELECT r.review_id, r.review_text, r.reviewer_name, r.rate, r.user_id, r.product_id, r.hidden
        FROM `product_reviews` r
        WHERE r.product_id = '$product_id' 
          AND r.hidden = '0'
        ORDER BY r.review_id DESC
    ");
    
    if ($sql_reviews) {
        while ($review = mysqli_fetch_assoc($sql_reviews)) {
            $reviews[] = [
                'id'         => $review['review_id'],
                'text'       => $review['review_text'],
                'user_name'  => $review['reviewer_name'],
                'user_id'    => $review['user_id'],
                'product_id' => $review['product_id'],
                'rate'       => $review['rate'],
            ];
        }
    }
    $formatted_product->reviews = $reviews;
    
    return success($formatted_product);
}
