<?php
// /user/payment_success.php

ini_set('display_errors', 1); // set to 0 in production
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/order-error.log');

require 'vendor/autoload.php';
// \Stripe\Stripe::setApiKey('sk_test_51MbycxKqjaL0X49YF3I3ZZ81fF772xlz4XB90p4nDxdYFWR4CyxOljSTiZy26eS3V9dZFrNotiSA8maUnAlmQG5M00dZqUUuCS');
\Stripe\Stripe::setApiKey('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');

$order_id   = isset($_GET['order_id']) ? (int)$_GET['order_id'] : 0;
$session_id = $_GET['session_id'] ?? '';

$paymentStatus   = null;   // what we show in UI
$currentStatus   = null;   // value stored in DB
$dbError         = '';
$updated         = false;
$alreadyUpdated  = false;
$stripeStatus    = null;   // PaymentIntent or Session status

if ($order_id > 0 && $session_id) {
    try {
        // 1) Retrieve the Checkout Session from Stripe
        $session = \Stripe\Checkout\Session::retrieve($session_id);

        $stripePaid = false;

        // 2) Prefer PaymentIntent status (more accurate)
        if (!empty($session->payment_intent)) {
            $pi = \Stripe\PaymentIntent::retrieve($session->payment_intent);
            $stripeStatus = $pi->status;  // e.g. 'succeeded', 'processing', 'requires_payment_method', 'canceled'

            if ($stripeStatus === 'succeeded') {
                $stripePaid    = true;
                $paymentStatus = 'success';
            } elseif (in_array($stripeStatus, [
                'processing',
                'requires_action',
                'requires_capture',
                'requires_confirmation'
            ], true)) {
                $paymentStatus = 'pending';
            } elseif (in_array($stripeStatus, [
                'failed',
                'requires_payment_method'
            ], true)) {
                $paymentStatus = 'failed';
            } else {
                $paymentStatus = 'pending';
            }
        } else {
            // 3) Fallback to Checkout Session payment_status
            $stripeStatus = $session->payment_status ?? null; // 'paid', 'unpaid', 'no_payment_required'

            if ($stripeStatus === 'paid') {
                $stripePaid    = true;
                $paymentStatus = 'success';
            } elseif ($stripeStatus === 'unpaid') {
                $paymentStatus = 'failed';
            } else {
                $paymentStatus = 'pending';
            }
        }

        // 4) Update local DB if not finalized yet
        require __DIR__ . '/../connect.php';

        if (isset($con) && $con instanceof mysqli && !$con->connect_error) {
            // Get current payment_status
            $stmt = $con->prepare("SELECT payment_status FROM orders WHERE order_id = ?");
            if ($stmt) {
                $stmt->bind_param('i', $order_id);
                $stmt->execute();
                $res = $stmt->get_result();
                $row = $res->fetch_assoc();
                $stmt->close();

                if ($row) {
                    $currentStatus = $row['payment_status'];

                    // Only update if NULL / '' / 'pending'
                    if ($currentStatus === null ||
                        $currentStatus === '' ||
                        strtolower($currentStatus) === 'pending') {

                        $newStatus = $paymentStatus; // 'success', 'pending' or 'failed'

                        $stmt2 = $con->prepare("
                            UPDATE orders 
                            SET payment_status = ?, session_id = ? 
                            WHERE order_id = ?
                        ");
                        if ($stmt2) {
                            $stmt2->bind_param('ssi', $newStatus, $session_id, $order_id);
                            $stmt2->execute();
                            $stmt2->close();

                            $updated       = true;
                            $currentStatus = $newStatus;
                        } else {
                            $dbError = 'Failed to prepare update statement: ' . $con->error;
                        }

                    } else {
                        // Already success / cancelled / something else – don't override
                        $alreadyUpdated = true;
                        if (!empty($currentStatus)) {
                            $paymentStatus = $currentStatus;
                        }
                    }
                } else {
                    $dbError = 'Order not found.';
                }
            } else {
                $dbError = 'Failed to prepare select statement: ' . $con->error;
            }
        } else {
            $dbError = 'Database connection error.';
        }

    } catch (Throwable $e) {
        $dbError = 'Stripe exception: ' . $e->getMessage();
    }
} else {
    $dbError = 'Missing order_id or session_id in URL.';
}

// Fallback if no status was detected at all
if ($paymentStatus === null) {
    $paymentStatus = 'pending';
}

// =========== UI VARIABLES BASED ON PAYMENT STATUS ===========
$normalized = strtolower($paymentStatus);

switch ($normalized) {
    case 'success':
        $bodyClass      = 'status-success';
        $titleText      = 'Thank you for your order! 🌸';
        $subtitleText   = 'Your Tiffany Flowers arrangement is being prepared with love.';
        $noteText       = 'A confirmation email will be sent with all the details of your order.';
        $btnLabel       = 'Continue shopping';
        $btnHref        = 'https://tiffanyflowers.ae/';
        $pillClass      = 'success';
        $iconType       = 'check';
        break;

    case 'failed':
        $bodyClass      = 'status-failed';
        $titleText      = 'Payment failed';
        $subtitleText   = 'Something went wrong while processing your payment.';
        $noteText       = 'If money was deducted from your card, please contact support with your order number.';
        $btnLabel       = 'Try again';
        $btnHref        = 'https://tiffanyflowers.ae/cart';
        $pillClass      = 'failed';
        $iconType       = 'cross';
        break;

    case 'pending':
    default:
        $bodyClass      = 'status-pending';
        $titleText      = 'Payment is being processed';
        $subtitleText   = 'We are confirming your payment with your bank. This may take a few moments.';
        $noteText       = 'You will receive an email once your payment is confirmed. If you have any questions, please contact us.';
        $btnLabel       = 'Back to homepage';
        $btnHref        = 'https://tiffanyflowers.ae/';
        $pillClass      = 'pending';
        $iconType       = 'clock';
        break;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payment Status - Tiffany Flowers</title>
    <style>
        :root {
            /* Approximate Tiffany Flowers brand-like palette */
            --primary: #d19acb;        /* soft pink/purple like site accents */
            --primary-dark: #a563a0;   /* deeper plum */
            --accent-gold: #cfa25a;    /* warm gold accent */
            --bg: #fdf6fb;
            --text: #2f2341;
            --success: #16a34a;
            --warning: #b45309;
            --danger: #b91c1c;
        }
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
            min-height: 100vh;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--text);
            background: radial-gradient(circle at top, #fde7f4 0, var(--bg) 40%, #f6e8ff 100%);
        }

        /* Background variations */
        body.status-success {
            background: radial-gradient(circle at top, #dcfce7 0, #fdf6fb 40%, #f6e8ff 100%);
        }
        body.status-pending {
            background: radial-gradient(circle at top, #fef9c3 0, #fdf6fb 40%, #f6e8ff 100%);
        }
        body.status-failed {
            background: radial-gradient(circle at top, #fee2e2 0, #fdf6fb 40%, #f6e8ff 100%);
        }

        .card {
            background: #ffffff;
            max-width: 520px;
            width: 100%;
            padding: 32px 28px 28px;
            border-radius: 18px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.08);
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .card::before {
            content: "";
            position: absolute;
            inset: -40%;
            background:
              radial-gradient(circle at 0 0, rgba(209,154,203,0.16), transparent 60%),
              radial-gradient(circle at 100% 0, rgba(244,144,192,0.14), transparent 55%);
            opacity: 0.9;
            z-index: -1;
        }

        /* Icon circle variations */
        .icon-circle {
            width: 68px;
            height: 68px;
            border-radius: 999px;
            margin: 0 auto 18px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        body.status-success .icon-circle {
            background: radial-gradient(circle at 30% 0, #bbf7d0, #22c55e);
            box-shadow: 0 10px 25px rgba(22,163,74,0.35);
        }
        body.status-pending .icon-circle {
            background: radial-gradient(circle at 30% 0, #fef9c3, #eab308);
            box-shadow: 0 10px 25px rgba(250,204,21,0.35);
        }
        body.status-failed .icon-circle {
            background: radial-gradient(circle at 30% 0, #fee2e2, #dc2626);
            box-shadow: 0 10px 25px rgba(220,38,38,0.35);
        }
        .icon-circle svg {
            width: 34px;
            height: 34px;
            color: white;
        }

        h1 {
            font-size: 1.5rem;
            margin-bottom: 6px;
        }
        .subtitle {
            font-size: 0.95rem;
            color: #6b607d;
            margin-bottom: 18px;
        }
        .order-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            font-size: 0.85rem;
            padding: 6px 12px;
            border-radius: 999px;
            background: rgba(207,162,90,0.08);
            color: var(--accent-gold);
            margin-bottom: 18px;
        }
        .order-badge span.code {
            font-weight: 600;
        }

        .status-pill {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: .06em;
        }
        .status-pill.success {
            background: rgba(22,163,74,0.1);
            color: var(--success);
        }
        .status-pill.pending {
            background: rgba(234,179,8,0.1);
            color: var(--warning);
        }
        .status-pill.failed {
            background: rgba(220,38,38,0.08);
            color: var(--danger);
        }

        .details {
            background: rgba(255,255,255,0.95);
            border-radius: 12px;
            padding: 14px 16px;
            font-size: 0.9rem;
            margin-bottom: 22px;
            border: 1px solid #f3e8ff;
        }
        .details-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 4px;
        }
        .details-row span.label {
            color: #6b607d;
        }
        .details-row span.value {
            font-weight: 600;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 10px 20px;
            border-radius: 999px;
            border: none;
            cursor: pointer;
            font-size: 0.95rem;
            font-weight: 600;
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            text-decoration: none;
            box-shadow: 0 10px 25px rgba(148,66,138,0.35);
            transition: transform 0.15s ease, box-shadow 0.15s ease;
        }
        .btn:hover {
            transform: translateY(-1px);
            box-shadow: 0 14px 30px rgba(148,66,138,0.4);
        }
        .note {
            font-size: 0.8rem;
            color: #8b7a9b;
            margin-top: 10px;
        }
        .debug {
            margin-top: 12px;
            font-size: 0.75rem;
            color: #7f1d1d;
            background: rgba(254,226,226,0.9);
            border-radius: 8px;
            padding: 8px 10px;
            text-align: left;
            max-width: 460px;
            margin-left: auto;
            margin-right: auto;
            white-space: pre-wrap;
        }
    </style>
</head>
<body class="<?php echo htmlspecialchars($bodyClass); ?>">
<div class="card">
    <div class="icon-circle">
        <?php if ($iconType === 'check'): ?>
            <!-- Success icon -->
            <svg viewBox="0 0 24 24" fill="none">
                <path d="M20 6L9 17L4 12" stroke="white" stroke-width="2.2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        <?php elseif ($iconType === 'clock'): ?>
            <!-- Pending icon -->
            <svg viewBox="0 0 24 24" fill="none">
                <circle cx="12" cy="12" r="9" stroke="white" stroke-width="2.2"/>
                <path d="M12 7v5l3 2" stroke="white" stroke-width="2.2" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
        <?php else: ?>
            <!-- Failed icon -->
            <svg viewBox="0 0 24 24" fill="none">
                <circle cx="12" cy="12" r="9" stroke="white" stroke-width="2.2"/>
                <path d="M9 9l6 6M15 9l-6 6" stroke="white" stroke-width="2.2" stroke-linecap="round"/>
            </svg>
        <?php endif; ?>
    </div>

    <h1><?php echo htmlspecialchars($titleText); ?></h1>
    <p class="subtitle">
        <?php echo htmlspecialchars($subtitleText); ?>
    </p>

    <div class="order-badge">
        <span>Order</span>
        <span class="code">#<?php echo htmlspecialchars($order_id ?: '-'); ?></span>
        <span class="status-pill <?php echo htmlspecialchars($pillClass); ?>">
            <?php echo ucfirst($paymentStatus); ?>
        </span>
    </div>

    <div class="details">
        <div class="details-row">
            <span class="label">Payment status</span>
            <span class="value">
                <?php echo ucfirst($paymentStatus); ?>
            </span>
        </div>
        <div class="details-row">
            <span class="label">Payment method</span>
            <span class="value">Card via Stripe</span>
        </div>
    </div>

    <a class="btn" href="<?php echo htmlspecialchars($btnHref); ?>">
        <?php echo htmlspecialchars($btnLabel); ?>
    </a>

    <p class="note">
        <?php echo htmlspecialchars($noteText); ?>
    </p>

    <!--<?php if ($dbError): ?>-->
    <!--    <div class="debug">-->
    <!--        <strong>Debug info (remove in production):</strong><br>-->
    <!--        <?php echo htmlspecialchars($dbError); ?>-->
    <!--    </div>-->
    <!--<?php elseif ($alreadyUpdated): ?>-->
    <!--    <div class="debug">-->
    <!--        Payment status in DB was already "<?php echo htmlspecialchars((string)$currentStatus); ?>" - not changed.-->
    <!--    </div>-->
    <!--<?php elseif ($updated): ?>-->
    <!--    <div class="debug">-->
    <!--        Payment status updated to "<?php echo htmlspecialchars((string)$currentStatus); ?>" for order #<?php echo htmlspecialchars($order_id); ?>.-->
    <!--    </div>-->
    <!--<?php endif; ?>-->
</div>
</body>
</html>
