<?php
// /user/payment_pending.php

ini_set('display_errors', 1); // set to 0 in production
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/order-error.log');

require 'vendor/autoload.php';
\Stripe\Stripe::setApiKey('sk_test_51MbycxKqjaL0X49YF3I3ZZ81fF772xlz4XB90p4nDxdYFWR4CyxOljSTiZy26eS3V9dZFrNotiSA8maUnAlmQG5M00dZqUUuCS');
// \Stripe\Stripe::setApiKey('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');

$order_id   = isset($_GET['order_id']) ? (int)$_GET['order_id'] : 0;
$session_id = $_GET['session_id'] ?? '';

$dbError        = '';
$updated        = false;
$alreadyUpdated = false;
$currentStatus  = null;
$paymentStatus  = null; // default
$stripeStatus   = null;

if ($order_id > 0 && $session_id) {
    try {
        $session = \Stripe\Checkout\Session::retrieve($session_id);

        if (!empty($session->payment_intent)) {
            $pi = \Stripe\PaymentIntent::retrieve($session->payment_intent);
            $stripeStatus = $pi->status;

            if ($stripeStatus === 'succeeded') {
                $paymentStatus = 'success';
            } elseif (in_array($stripeStatus, [
                'processing',
                'requires_action',
                'requires_capture',
                'requires_confirmation'
            ], true)) {
                $paymentStatus = 'pending';
            } elseif (in_array($stripeStatus, [
                'canceled',
                'requires_payment_method'
            ], true)) {
                $paymentStatus = 'failed';
            } else {
                $paymentStatus = 'cancelled';
            }
        } else {
            $stripeStatus = $session->payment_status ?? null;
            if ($stripeStatus === 'paid') {
                $paymentStatus = 'success';
            } elseif ($stripeStatus === 'unpaid') {
                $paymentStatus = 'failed';
            } else {
                $paymentStatus = 'pending';
            }
        }

        require __DIR__ . '/../connect.php';
        if (isset($con) && $con instanceof mysqli && !$con->connect_error) {
            $stmt = $con->prepare("SELECT payment_status FROM orders WHERE order_id = ?");
            if ($stmt) {
                $stmt->bind_param('i', $order_id);
                $stmt->execute();
                $res = $stmt->get_result();
                $row = $res->fetch_assoc();
                $stmt->close();

                if ($row) {
                    $currentStatus = $row['payment_status'];

                    // Only update if NULL / '' (we usually leave 'pending' alone here)
                    if ($currentStatus === null || $currentStatus === '') {
                        $newStatus = $paymentStatus;

                        $stmt2 = $con->prepare("UPDATE orders SET payment_status = ? WHERE order_id = ?");
                        if ($stmt2) {
                            $stmt2->bind_param('si', $newStatus, $order_id);
                            $stmt2->execute();
                            $stmt2->close();
                            $updated       = true;
                            $currentStatus = $newStatus;
                        } else {
                            $dbError = 'Failed to prepare update statement: ' . $con->error;
                        }
                    } else {
                        $alreadyUpdated = true;
                        if (!empty($currentStatus)) {
                            $paymentStatus = $currentStatus;
                        }
                    }
                } else {
                    $dbError = 'Order not found.';
                }
            } else {
                $dbError = 'Failed to prepare select statement: ' . $con->error;
            }
        } else {
            $dbError = 'Database connection error.';
        }

    } catch (Throwable $e) {
        $dbError = 'Stripe exception: ' . $e->getMessage();
    }
} else {
    $dbError = 'Missing order_id or session_id in URL.';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Payment Pending - Tiffany Flowers</title>
    <style>
        :root {
            --primary: #4f46e5;
            --bg: #eef2ff;
            --text: #111827;
        }
        * { margin:0; padding:0; box-sizing:border-box; }
        body {
            min-height: 100vh;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #e0e7ff 0, #eef2ff 40%, #f5f3ff 100%);
            display:flex;
            align-items:center;
            justify-content:center;
            color:var(--text);
        }
        .card {
            background:#fff;
            max-width:480px;
            width:100%;
            padding:30px 26px 26px;
            border-radius:18px;
            box-shadow:0 18px 35px rgba(79,70,229,0.18);
            text-align:center;
            position: relative;
            overflow: hidden;
        }
        .card::before {
            content: "";
            position: absolute;
            inset: -30%;
            background:
              radial-gradient(circle at 0 0, rgba(79,70,229,0.15), transparent 55%),
              radial-gradient(circle at 100% 0, rgba(129,140,248,0.15), transparent 60%);
            opacity: 0.8;
            z-index: -1;
        }
        .icon-circle {
            width:64px; height:64px;
            border-radius:999px;
            margin:0 auto 16px;
            display:flex;
            align-items:center;
            justify-content:center;
            background:radial-gradient(circle at 30% 0, #c7d2fe, #4f46e5);
            box-shadow:0 12px 30px rgba(79,70,229,0.45);
        }
        .icon-circle svg {
            width:32px; height:32px;
            color:#fff;
        }
        h1 { font-size:1.5rem; margin-bottom:6px; }
        .subtitle {
            font-size:0.95rem;
            color:#4b5563;
            margin-bottom:18px;
        }
        .order {
            font-size:0.9rem;
            margin-bottom:14px;
            color:#4b5563;
        }
        .status-label {
            display:inline-block;
            padding:4px 10px;
            border-radius:999px;
            font-size:0.75rem;
            text-transform:uppercase;
            letter-spacing:.06em;
            background:rgba(79,70,229,0.08);
            color:#312e81;
            margin-bottom:18px;
        }
        .btn {
            display:inline-flex;
            align-items:center;
            justify-content:center;
            padding:10px 20px;
            border-radius:999px;
            border:none;
            cursor:pointer;
            font-size:0.95rem;
            font-weight:600;
            background:#111827;
            color:#fff;
            text-decoration:none;
            transition: transform .15s ease, box-shadow .15s ease;
            box-shadow:0 10px 25px rgba(15,23,42,0.35);
        }
        .btn:hover {
            transform: translateY(-1px);
            box-shadow:0 14px 30px rgba(15,23,42,0.45);
        }
        .note {
            margin-top:10px;
            font-size:0.8rem;
            color:#6b7280;
        }
        .debug {
            margin-top:12px;
            font-size:0.75rem;
            color:#7f1d1d;
            background:rgba(254,226,226,0.9);
            border-radius:8px;
            padding:8px 10px;
            text-align:left;
            max-width:420px;
            margin-left:auto;
            margin-right:auto;
            white-space:pre-wrap;
        }
    </style>
</head>
<body>
<div class="card">
    <div class="icon-circle">
        <svg viewBox="0 0 24 24" fill="none">
            <circle cx="12" cy="12" r="9" stroke="white" stroke-width="2"/>
            <path d="M12 7v5l3 3" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        </svg>
    </div>
    <h1>Payment pending</h1>
    <p class="subtitle">
        We’re still confirming your payment. This can take a few moments.
    </p>
    <p class="order">
        <?php if ($order_id): ?>
            Order #: <strong><?php echo htmlspecialchars($order_id); ?></strong>
        <?php else: ?>
            We couldn’t detect a valid order number.
        <?php endif; ?>
    </p>

    <div class="status-label">
        Status: <?php echo ucfirst($paymentStatus); ?>
    </div>

    <a class="btn" href="https://tiffanyflowers.ae/">
        Go to home
    </a>
    <p class="note">
        You’ll see the final status of your order in your email or your account shortly.
    </p>

    <?php if ($dbError): ?>
        <div class="debug">
            <strong>Debug info (remove in production):</strong><br>
            <?php echo htmlspecialchars($dbError); ?>
        </div>
    <?php elseif ($alreadyUpdated): ?>
        <div class="debug">
            Payment status was already "<?php echo htmlspecialchars((string)$currentStatus); ?>" — not changed.
        </div>
    <?php elseif ($updated): ?>
        <div class="debug">
            Payment status set to "<?php echo htmlspecialchars((string)$currentStatus); ?>" for order #<?php echo htmlspecialchars($order_id); ?>.
        </div>
    <?php endif; ?>
</div>
</body>
</html>
