<?php
require_once "../connect.php";

ini_set('display_errors', false);
ini_set('log_errors', true);
ini_set('error_log', __DIR__ . '/error.log');

// Start timing
$start_time = microtime(true);

if (!$con) {
    error_log('Database connection failed: ' . mysqli_connect_error());
    exit('Database connection failed');
}

// Check if embedding column exists
$check_column = $con->query("SHOW COLUMNS FROM products LIKE 'embedding'");
if ($check_column->num_rows === 0) {
    error_log('Embedding column missing in products table');
    exit('Embedding column missing');
}

$api_key = 'sk-proj-iDw4Lwlzq8CU2hiFP0onlzQJCt40PQ10BzCTdJcriwAKIEN1D8vWp9D8qOpZDJalb37ErY8JtZT3BlbkFJ_CC4VnhxjNGYSD18gs5rPeTx-0KGE_xLRmpfyWJ8QJ81JsSGbZJh5zLbREwpvRmLYQcTjioA'; // Replace with valid OpenAI API key

// Function to generate embedding
function generateEmbedding($text, $api_key) {
    if (empty($text)) {
        error_log('Empty text provided for embedding');
        return null;
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/embeddings');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $api_key,
        'Content-Type: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode([
        'model' => 'text-embedding-ada-002',
        'input' => $text
    ]));
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);

    if ($http_code !== 200 || $curl_error) {
        error_log("Embedding API error: HTTP $http_code, cURL error: $curl_error, Response: " . substr($response, 0, 500));
        return null;
    }

    $response_data = json_decode($response, true);
    if (!isset($response_data['data'][0]['embedding'])) {
        error_log('Invalid embedding response: ' . json_last_error_msg());
        return null;
    }

    return $response_data['data'][0]['embedding'];
}

// Fetch products without embeddings
$batch_size = 100;
$offset = 0;
$processed = 0;
$failed = 0;

while (true) {
    $sql = "SELECT product_id, product_name, product_name_en, product_description, product_description_en 
            FROM products 
            WHERE embedding IS NULL OR embedding = '' 
            LIMIT $batch_size OFFSET $offset";
    $result = $con->query($sql);

    if (!$result) {
        error_log('Query failed: ' . $con->error);
        exit('Query failed');
    }

    if ($result->num_rows === 0) {
        break; // No more products to process
    }

    while ($row = $result->fetch_assoc()) {
        $product_id = $row['product_id'];
        // Combine fields for embedding
        $text = trim(implode(' ', array_filter([
            $row['product_name'],
            $row['product_name_en'],
            $row['product_description'],
            $row['product_description_en']
        ])));

        if (empty($text)) {
            error_log("Product ID $product_id has no text for embedding");
            $failed++;
            continue;
        }

        $embedding = generateEmbedding($text, $api_key);
        if ($embedding === null) {
            error_log("Failed to generate embedding for product ID $product_id");
            $failed++;
            continue;
        }

        // Update product with embedding
        $embedding_json = json_encode($embedding);
        $stmt = $con->prepare("UPDATE products SET embedding = ? WHERE product_id = ?");
        if (!$stmt) {
            error_log("Prepare failed for product ID $product_id: " . $con->error);
            $failed++;
            continue;
        }

        $stmt->bind_param('si', $embedding_json, $product_id);
        if ($stmt->execute()) {
            $processed++;
            error_log("Generated embedding for product ID $product_id");
        } else {
            error_log("Update failed for product ID $product_id: " . $stmt->error);
            $failed++;
        }
        $stmt->close();
    }

    $offset += $batch_size;
    $result->free();
    sleep(1); // Avoid overwhelming API
}

$con->close();

$execution_time = microtime(true) - $start_time;
error_log("Processed $processed products, failed $failed in $execution_time seconds");

echo "Processed $processed products, failed $failed in $execution_time seconds\n";
?>