<?php

require "../../connect.php";

if ($requestMethod == "POST") {
    $res = favorites();
    echo $res;
} else {
    echo error405($requestMethod);
}

function favorites()
{

    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);
    $headers = array_change_key_case(getallheaders(), CASE_LOWER);
    $lang = strtolower(trim($headers['lang'] ?? ''));


    if (!isset($obj['user_id'])) {
        return error('user id is missing in url');
    }

    global $con;
    

    $favorites = array();

    $response = new stdClass();

    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    

    if (empty(trim($obj['user_id']))) {
        return error('ادخل معرف المستخدم');
    }

    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$user_id'");
    if(mysqli_num_rows($sql_select) != 1){
        return error("معرف المستخدم غير موجود");
    }
    
    $blocked_ids = [];
    
    $blocked_query = mysqli_query($con, "
        SELECT user_blocked_id as id FROM user_blocks WHERE user_id = '$user_id'
        UNION
        SELECT user_id as id FROM user_blocks WHERE user_blocked_id = '$user_id'
    ");
    
    while ($row = mysqli_fetch_assoc($blocked_query)) {
        $blocked_ids[] = $row['id'];
    }
    
    if (!empty($blocked_ids)) {
        mysqli_query($con, "
            DELETE f FROM favorites f
            JOIN products p ON f.favorite_productId = p.product_id
            WHERE f.favorite_userId = '$user_id'
            AND p.seller_id IN (" . implode(',', array_map('intval', $blocked_ids)) . ")
        ");
    }
    
    $blocked_ids_sql = "";
    if (!empty($blocked_ids)) {
        $blocked_ids_sql = " AND `seller_id` NOT IN (" . implode(',', array_map('intval', $blocked_ids)) . ")";
    }
    
    $sql_select = mysqli_query($con, "
        SELECT f.* 
        FROM favorites f
        JOIN products p ON f.favorite_productId = p.product_id
        WHERE f.favorite_userId = '$user_id'
        $blocked_ids_sql
        ");
    
    

    if ($sql_select) {
        if (mysqli_num_rows($sql_select) > 0) {
            while ($favorite_item = mysqli_fetch_object($sql_select)) {
                $sql_select_favorite = mysqli_query($con, "
                    SELECT * FROM `products` 
                    WHERE `product_id` = '$favorite_item->favorite_productId'
                    $blocked_ids_sql
                ");
                $product = mysqli_fetch_object($sql_select_favorite);
                if (!$product) {
                    continue;
                }

                $images = array();
                $sql_select_images = mysqli_query($con, "SELECT * FROM `product_images` WHERE `product_id` = '$product->product_id'");
                while ($image = mysqli_fetch_object($sql_select_images)) {
                    $images[] = $image;
                }

                $product->images = $images;
                $product->product_name = $lang == 'en' ? $product->product_name_en : $product->product_name;
                $product->product_description = $lang == 'en' ? $product->product_description_en : $product->product_description;
                // $product->discount_percentage = round(100 * ($product->product_discount / $product->product_price), 2);
                        $product->old_price = $product->product_price * 1;
                        // $product->new_price = $product->product_price - $product->product_discount;
                        $product->new_price = $product->product_price ;

                $sql_select_favorite = mysqli_query($con, "SELECT * FROM `favorites` WHERE `favorite_userId` = '$user_id' AND `favorite_productId` = '$product->product_id'");
    if (mysqli_num_rows($sql_select_favorite) > 0) {
        $product->in_favorite = true;
    } else {
        $product->in_favorite = false;
    }

    $sql_select_cart = mysqli_query($con, "SELECT * FROM `cart` WHERE `item_userId` = '$user_id' AND `item_productId` = '$product->product_id'");
    if (mysqli_num_rows($sql_select_cart) > 0) {
        $product->in_cart = true;
    } else {
        $product->in_cart = false;
    }

                unset($product->hidden,$product->product_rejectImage,$product->product_rejectReason,$product->product_status);
                $favorite_item->product = $product;
                unset($favorite_item->favorite_userId,$favorite_item->favorite_productId);
                $favorites[] = $favorite_item;
            }

            return success($favorites);
        } else {
            return emptyList();
        }
    } else {
        return serverError();
    }
    return json_encode($response);
}
