<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require 'vendor/autoload.php';
// \Stripe\Stripe::setApiKey('sk_test_51MbycxKqjaL0X49YF3I3ZZ81fF772xlz4XB90p4nDxdYFWR4CyxOljSTiZy26eS3V9dZFrNotiSA8maUnAlmQG5M00dZqUUuCS');
\Stripe\Stripe::setApiKey('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');
header("Access-Control-Allow-Origin: *"); 
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization, lang");

// echo $_SERVER['REQUEST_METHOD'];
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__.'/order-error.log');
error_reporting(E_ALL);

function jsonResponse($data, $code = 200) {
    http_response_code($code);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    exit;
}
function apiError($msg, $code = 400) {
    jsonResponse(['success' => false, 'message' => $msg], $code);
}
function apiSuccess($data = [], $msg = 'Success') {
    jsonResponse(['success' => true, 'message' => $msg, 'data' => $data]);
}


$input = file_get_contents('php://input');
if (!$input) apiError('Empty request');
$req = json_decode($input, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    apiError('Invalid JSON');
}


$action = $req['action'];


function createOrder() {
    // Use POST only
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        apiError('Use POST method', 405);
    }

    // Read JSON body
    $input = file_get_contents('php://input');
    if (!$input) apiError('Empty request');

    $req = json_decode($input, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        apiError('Invalid JSON');
    }

    // ===== Extract data from request =====
    $user_id           = $req['user_id'] ?? 0;
    $phone_number      = trim($req['phone_number'] ?? '');
    $receiver_phone    = trim($req['receiver_phone_number'] ?? '');
    $receiver_address  = trim($req['receiver_address'] ?? '');
    $email             = trim($req['customer_email'] ?? 'info@tiffanyflowers.ae');
    $orders            = $req['cartData']['items'] ?? [];
    $shipping_cost     = (float)($req['shipping_cost'] ?? 0);
    $message           = trim($req['message'] ?? '');
    $bouquet_phrase    = trim($req['bouquet_phrase'] ?? '');

    // ===== Basic validation =====
    if (!$phone_number)         apiError('Your phone is required');
    if (!$receiver_phone)       apiError('Receiver phone is required');
    if (!$receiver_address)     apiError('Delivery address is required');
    if (empty($orders))         apiError('No items in order');

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Fallback email if invalid
        $email = 'customer@example.com';
    }

    // ===== Recalculate totals & build Stripe line_items =====
    $line_items = [];
    $subtotal   = 0;

    foreach ($orders as $item) {
        $product_id   = (int)($item['product_id'] ?? 0);
        $quantity     = max(1, (int)($item['quantity'] ?? 1));

        // Prefer unit_price, fallback to new_price or price from frontend
        $unit_price   = (float)($item['unit_price']
                        ?? $item['new_price']
                        ?? $item['price']
                        ?? 0);

        // Product name (Arabic / English / generic)
        $product_name = trim(
              $item['product_name_ar']
            ?? $item['product_name_en']
            ?? $item['product_name']
            ?? "Product #$product_id"
        );
        $product_name = $product_name ?: "Item #$product_id";

        if ($product_id <= 0) {
            apiError('Invalid product ID');
        }
        if ($quantity < 1) {
            apiError('Invalid quantity');
        }
        if ($unit_price <= 0) {
            apiError("Invalid price for product #$product_id");
        }

        $item_total = $unit_price * $quantity;
        $subtotal  += $item_total;

        $line_items[] = [
            'price_data' => [
                'currency'     => 'AED', // change if you charge in another currency
                'product_data' => [
                    'name' => mb_substr($product_name, 0, 100), // Stripe max name length
                ],
                'unit_amount'  => (int) round($unit_price * 100), // in cents
            ],
            'quantity' => $quantity,
        ];
    }

    $final_total = round($subtotal + $shipping_cost, 2);

    if ($final_total <= 0) {
        apiError('Total amount cannot be zero');
    }

    // Add shipping cost as a separate Stripe line item (if > 0)
    if ($shipping_cost > 0) {
        $line_items[] = [
            'price_data' => [
                'currency'     => 'AED',
                'product_data' => ['name' => 'Shipping & Delivery'],
                'unit_amount'  => (int) round($shipping_cost * 100),
            ],
            'quantity' => 1,
        ];
    }

    // ===== Save order in database =====
    require __DIR__ . '/../connect.php';
    if (!$con || $con->connect_error) {
        apiError('Database error', 500);
    }

    $con->autocommit(false);
$delivery_id = $req['delivery_id'];
    try {
        // Insert main order
        $stmt = $con->prepare("
            INSERT INTO orders (user_id, address_id, shipping_cost, total, created_at, delivery_id)
            VALUES (?, 0, ?, ?, NOW(), ?)
        ");
        $stmt->bind_param('iddi', $user_id, $shipping_cost, $final_total, $delivery_id);
        $stmt->execute();
        $order_id = $con->insert_id;
        $stmt->close();

        // Insert order items
        $stmtItem = $con->prepare("
            INSERT INTO order_items (order_id, product_id, price, quantity)
            VALUES (?, ?, ?, ?)
        ");
        foreach ($orders as $item) {
            $pid   = (int) $item['product_id'];
            $price = (float) ($item['unit_price']
                      ?? $item['new_price']
                      ?? $item['price']
                      ?? 0);
            $qty   = (int) $item['quantity'];

            $stmtItem->bind_param('iidi', $order_id, $pid, $price, $qty);
            $stmtItem->execute();
        }
        $stmtItem->close();

        // Optional: save gift message / bouquet phrase
        if ($message || $bouquet_phrase) {
            $stmtGift = $con->prepare("
                INSERT INTO order_gifts (order_id, gift_message, receiver_address, recipient_phone)
                VALUES (?, ?, ?, ?)
            ");
            $gift_msg = $bouquet_phrase ?: $message;
            $stmtGift->bind_param('isss', $order_id, $gift_msg, $receiver_address, $receiver_phone);
            $stmtGift->execute();
            $stmtGift->close();
        }

        $con->commit();
    } catch (Throwable $e) {
        $con->rollback();
        apiError('Order failed: ' . $e->getMessage(), 500);
    }

    $con->autocommit(true);

    // ===== Create Stripe Checkout Session (LIVE because of sk_live key) =====
    try {
        $session = \Stripe\Checkout\Session::create([
            'payment_method_types' => ['card'],
             
            'line_items'           => $line_items,
            'mode'                 => 'payment', // ✅ correct mode
            'customer_email'       => $email,
            'metadata'             => [
                'order_id' => $order_id,
                'user_id'  => $user_id ?: 'guest',
            ],
            'success_url' => 'https://api.tiffanyflowers.ae/user/payment_success.php?session_id={CHECKOUT_SESSION_ID}&order_id=' . $order_id,
'cancel_url'  => 'https://api.tiffanyflowers.ae/user/payment_cancel.php?session_id={CHECKOUT_SESSION_ID}&order_id=' . $order_id,

        ]);
        
        $session_url = $session->url;
        $session_id = $session->id;
        mysqli_query($con, "UPDATE orders SET session_id = '$session_id', payment_link='$session_url' WHERE order_id = '$order_id'");

        apiSuccess([
            'order_id'     => $order_id,
            'session_id'   => $session->id,
            'checkout_url' => $session->url,
            'total'        => $final_total,
            'currency'     => 'AED',
        ], 'Order created successfully!');

    } catch (\Stripe\Exception\ApiErrorException $e) {
        error_log('Stripe Error: ' . $e->getMessage());
        apiError('Payment failed: ' . $e->getMessage(), 500);
    }
}



function listOrders(){
global $jsonResponse, $apiError, $apiSuccess, $req;

$user_id = trim($req['user_id'] ?? '');
$lang    = in_array($req['lang'] ?? '', ['ar','en']) ? $req['lang'] : 'ar';

if (!$user_id) {
    apiError($lang === 'ar' ? 'معرف المستخدم مطلوب' : 'user_id is required');
}

require __DIR__.'/../connect.php';
if (!$con || $con->connect_error) {
    apiError('Database error', 500);
}

$orders = [];
$stmt = $con->prepare("
    SELECT 
        o.order_id,
        o.user_id,
        o.address_id,
        o.shipping_cost,
        o.total,
        o.status,
        o.created_at,
        a.full_address,
        g.recipient_phone AS address_phone,
        g.recipient_name,
        g.recipient_phone,
        g.gift_message,
        g.receiver_address,
        g.additional_info
    FROM orders o
    LEFT JOIN (
        SELECT address_id, 
               CONCAT(street, ', ', building_number, ', ', gover) AS full_address
        FROM addresses
    ) a ON a.address_id = o.address_id
    LEFT JOIN order_gifts g ON g.order_id = o.order_id
    WHERE o.user_id = ?
    ORDER BY o.created_at DESC
");
$stmt->bind_param('s', $user_id);
$stmt->execute();
$res = $stmt->get_result();

while ($order = $res->fetch_assoc()) {
    $order_id = $order['order_id'];

    $items = [];
    $itemStmt = $con->prepare("
        SELECT oi.product_id, oi.price, oi.quantity,
               p.product_name" . ($lang === 'en' ? '_en' : '') . " AS name,
              pi.*
        FROM order_items oi
        JOIN products p ON p.product_id = oi.product_id
        LEFT JOIN product_images pi ON p.product_id = pi.product_id
        WHERE oi.order_id = ?
    ");
    $itemStmt->bind_param('i', $order_id);
    $itemStmt->execute();
    $itemRes = $itemStmt->get_result();

    while ($item = $itemRes->fetch_assoc()) {
        
        
        if (!empty($item['url'])) {
                if (!str_starts_with($item['url'], 'http')) {
                    $item['url'] = "https://api.tiffanyflowers.ae/admin/" . ltrim($item['url'], '/');
                }
            } else {
                $item['url'] ="https://api.tiffanyflowers.ae/admin/" . 'uploads/products/default.jpg'; // fallback image
            }

            $items[] = [
                'product_id'   => (int)$item['product_id'],
                'name'         => $item['name'] ?? 'Unknown Product',
                'price'        => (float)$item['price'],
                'quantity'     => (int)$item['quantity'],
                'url'        => $item['url']
            ];
        
        $items[] =$item;
    }
    $itemStmt->close();

    $orders[] = [
        'order_id'        => (int)$order_id,
        'total'           => (float)$order['total'],
        'shipping_cost'   => (float)$order['shipping_cost'],
        'status'          => $order['status'] ?? 'pending',
        'created_at'      => $order['created_at'],
        'address'         => $order['full_address'] ? [
            'full_address' => $order['full_address'],
            'phone'        => $order['address_phone']
        ] : null,
        'gift'            => $order['gift_message'] ? [
            'recipient_name'     => $order['recipient_name'] ?? "-",
            'recipient_phone'    => $order['recipient_phone'],
            'gift_message'       => $order['gift_message'],
            'receiver_address'   => $order['receiver_address'],
            'additional_info'    => $order['additional_info']
        ] : null,
        'items'           => $items
    ];
}
$stmt->close();

apiSuccess([
    'total_orders' => count($orders),
    'orders'       => $orders
], $lang === 'ar' ? 'تم جلب الطلبات بنجاح' : 'Orders loaded successfully');
}


function reOrder(){
    
    global $apiError, $apiSuccess, $req;

    $user_id  = trim($req['user_id'] ?? '');
    $order_id = (int)($req['order_id'] ?? 0);
    $lang     = in_array($req['lang'] ?? '', ['ar','en']) ? $req['lang'] : 'ar';

    if (!$user_id)  apiError($lang === 'ar' ? 'معرف المستخدم مطلوب' : 'user_id is required');
    if (!$order_id) apiError($lang === 'ar' ? 'معرف الطلب مطلوب' : 'order_id is required');

    require __DIR__.'/../connect.php';
    if (!$con || $con->connect_error) {
        apiError('Database error', 500);
    }

    // === 1. Fetch Original Order + Gift Info ===
    $stmt = $con->prepare("
        SELECT o.address_id, o.shipping_cost, o.total,
               g.gift_message, g.recipient_phone, g.receiver_address, g.additional_info
        FROM orders o
        LEFT JOIN order_gifts g ON g.order_id = o.order_id
        WHERE o.order_id = ?
    ");
    $stmt->bind_param('i', $order_id);
    $stmt->execute();
    $original = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if (!$original) {
        apiError($lang === 'ar' ? 'الطلب غير موجود أو غير مملوك لك' : 'Order not found or not yours');
    }

    // === 2. Fetch Order Items (with product names from DB) ===
    $items = [];
    $stmt = $con->prepare("
        SELECT oi.product_id, oi.price, oi.quantity,
               COALESCE(p.product_name_ar, p.product_name_en, p.product_name, 'Unknown Product') AS product_name
        FROM order_items oi
        JOIN products p ON p.product_id = oi.product_id
        WHERE oi.order_id = ?
    ");
    $stmt->bind_param('i', $order_id);
    $stmt->execute();
    $res = $stmt->get_result();
    while ($row = $res->fetch_assoc()) {
        $items[] = [
            'product_id'   => (int)$row['product_id'],
            'unit_price'   => (float)$row['price'],           // This is the correct price used before
            'quantity'     => (int)$row['quantity'],
            'product_name' => $row['product_name']
        ];
    }
    $stmt->close();

    if (empty($items)) {
        apiError($lang === 'ar' ? 'لا توجد عناصر في الطلب' : 'No items in order');
    }

    // === 3. Recalculate Total & Build Stripe Line Items ===
    $line_items = [];
    $subtotal   = 0;

    foreach ($items as $item) {
        $price    = round($item['unit_price'], 2);
        $qty      = $item['quantity'];
        $name     = mb_substr($item['product_name'], 0, 100); // Stripe limit

        if ($price <= 0 || $qty < 1) {
            continue; // Skip invalid items
        }

        $subtotal += $price * $qty;

        $line_items[] = [
            'price_data' => [
                'currency' => 'AED',
                'product_data' => ['name' => $name],
                'unit_amount'  => (int)round($price * 100),
            ],
            'quantity' => $qty,
        ];
    }

    $shipping_cost = (float)$original['shipping_cost'];
    $final_total   = round($subtotal + $shipping_cost, 2);

    if ($final_total <= 0) {
        apiError('Cannot reorder: total amount is zero');
    }

    // Add shipping line item
    if ($shipping_cost > 0) {
        $line_items[] = [
            'price_data' => [
                'currency' => 'AED',
                'product_data' => ['name' => 'Shipping & Delivery'],
                'unit_amount'  => (int)round($shipping_cost * 100),
            ],
            'quantity' => 1,
        ];
    }

    // === 4. Create New Order in DB ===
    $con->autocommit(false);
    try {
        // Insert new order
        $stmt = $con->prepare("
            INSERT INTO orders (user_id, address_id, shipping_cost, total, created_at)
            VALUES (?, ?, ?, ?, NOW())
        ");
        $addr_id = (int)$original['address_id'];
        $stmt->bind_param('iidd', $user_id, $addr_id, $shipping_cost, $final_total);
        $stmt->execute();
        $new_order_id = $con->insert_id;
        $stmt->close();

        // Insert items
        $stmtItem = $con->prepare("
            INSERT INTO order_items (order_id, product_id, price, quantity)
            VALUES (?, ?, ?, ?)
        ");
        foreach ($items as $item) {
            $stmtItem->bind_param('iidi', $new_order_id, $item['product_id'], $item['unit_price'], $item['quantity']);
            $stmtItem->execute();
        }
        $stmtItem->close();

        // Copy gift message if exists
        if (!empty($original['gift_message']) || !empty($original['receiver_address'])) {
            $stmtGift = $con->prepare("
                INSERT INTO order_gifts 
                (order_id, gift_message, recipient_phone, receiver_address, additional_info)
                VALUES (?, ?, ?, ?, ?)
            ");
            $msg  = $original['gift_message'] ?? '';
            $phone = $original['recipient_phone'] ?? '';
            $addr  = $original['receiver_address'] ?? '';
            $info  = $original['additional_info'] ?? '';
            $stmtGift->bind_param('issss', $new_order_id, $msg, $phone, $addr, $info);
            $stmtGift->execute();
            $stmtGift->close();
        }

        $con->commit();
    } catch (Throwable $e) {
        $con->rollback();
        apiError('Reorder failed: ' . $e->getMessage(), 500);
    }
    $con->autocommit(true);

    // === 5. Create Stripe Checkout Session ===
    try {
        $session = \Stripe\Checkout\Session::create([
            'payment_method_types' => ['card'],
            'line_items'           => $line_items,
            'mode'                 => 'payment',
            'customer_email'       => $req['email'] ?? null,
            'metadata'             => [
                'order_id'     => $new_order_id,
                'original_order_id' => $order_id,
                'user_id'      => $user_id
            ],
            'success_url' => 'https://yourdomain.com/success?session_id={CHECKOUT_SESSION_ID}&order_id=' . $new_order_id,
            'cancel_url'  => 'https://yourdomain.com/orders',
        ]);

        apiSuccess([
            'original_order_id' => $order_id,
            'new_order_id'      => $new_order_id,
            'total'             => $final_total,
            'session_id'        => $session->id,
            'checkout_url'      => $session->url
        ], $lang === 'ar' ? 'تم إعادة الطلب بنجاح!' : 'Order recreated successfully!');

    } catch (\Stripe\Exception\ApiErrorException $e) {
        error_log('Stripe ReOrder Error: ' . $e->getMessage());
        apiError('Payment setup failed: ' . $e->getMessage(), 500);
    }
}


if($action == "add"){
    createOrder();
}else if($action == "list"){
    listOrders();
}else if($action == "reorder"){
    reOrder();
}else{
   apiError('Invalid Action'); 
}


