<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require "../connect.php";
require "../lang.php";

$lang = get_current_language();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);
    
    if (!isset($obj['user_id'])) {
        echo json_encode([
            "status" => 400,
            "message" => trans()["user_id_required"][$lang],
            "is_blocked" => null
        ]);
        exit;
    }

    if (!isset($obj['user_blocked_id'])) {
        echo json_encode([
            "status" => 400,
            "message" => trans()["user_blocked_id_required"][$lang],
            "is_blocked" => null
        ]);
        exit;
    }

    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    $user_blocked_id = mysqli_real_escape_string($con, $obj['user_blocked_id']);

    if ($user_id == $user_blocked_id) {
        echo json_encode([
            "status" => 403,
            "message" => trans()["self_block"][$lang],
            "is_blocked" => null
        ]);
        exit;
    }

    
    $checkSql = "SELECT * FROM user_blocks WHERE user_id = ? AND user_blocked_id = ?";
    $stmt = $con->prepare($checkSql);
    $stmt->bind_param("ii", $user_id, $user_blocked_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 0) {
        $sql = "INSERT INTO user_blocks (user_id, user_blocked_id) VALUES (?, ?)";
        $stmt = $con->prepare($sql);
        $stmt->bind_param("ii", $user_id, $user_blocked_id);

        if ($stmt->execute()) {
            $deleteFollowSql = "DELETE FROM user_followers 
                    WHERE (follower_id = ? AND followed_userId = ?) 
                    OR (follower_id = ? AND followed_userId = ?)";
            $stmtFollow = $con->prepare($deleteFollowSql);
            $stmtFollow->bind_param("iiii", $user_id, $user_blocked_id, $user_blocked_id, $user_id);
            $stmtFollow->execute();
            
            echo json_encode([
                "status" => 200,
                "message" => trans()["user_blocked_successfully"][$lang],
                "is_blocked" => 1
            ]);
            
        } else {
            echo json_encode([
                "status" => 500,
                "message" => trans()["error_blocking_user"][$lang],
                "is_blocked" => null
            ]);
            exit;
        }
    } else {
        $sql = "DELETE FROM user_blocks WHERE user_id = ? AND user_blocked_id = ?";
        $stmt = $con->prepare($sql);
        $stmt->bind_param("ii", $user_id, $user_blocked_id);

        if ($stmt->execute()) {
            echo json_encode([
                "status" => 200,
                "message" => trans()["user_unblocked_successfully"][$lang],
                "is_blocked" => 0
            ]);
        } else {
            echo json_encode([
                "status" => 500,
                "message" => trans()["error_blocking_user"][$lang],
                "is_blocked" => null
            ]);
            exit;
        }
    }
} else {
    echo json_encode([
        "status" => 405,
        "message" => trans()["method_not_allowed"][$lang],
        "is_blocked" => null
    ]);
    exit;
}
