<?php

require "../../connect.php";

if ($_SERVER['REQUEST_METHOD'] == "POST") {
    $res = signup();
    echo $res;
} else {
    echo error405($_SERVER['REQUEST_METHOD']);
}

function signup()
{
    global $con;
    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);

    
    if (!isset($obj['phone'])) {
        return error("Enter 'phone' in the request body");
    }

    $phone = mysqli_real_escape_string($con, $obj['phone']);
    $verifyCode = rand(1000, 9999);

    
    if (empty(trim($phone))) {
        return error('Enter your phone');
    }

    
    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_phone` = '$phone'");
    if ($sql_select && mysqli_num_rows($sql_select) > 0) {
        return error('This phone is already registered');
    }

    
    $inc_id = '673C9ADDEE2B8'; 
    $acc_tok = '671f99db774ad'; 
    $apiKey = ''; 

    
    $url = 'https://app.wawp.net/api/send';
    $data = [
        'number' => intval($phone),
        'phone' => intval($phone),
        'type' => 'text',
        'instance_id' => $inc_id,
        'access_token' => $acc_tok,
        'message' => $verifyCode
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
    ]);

    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    
    if ($http_code == 200) {
        // $sql_update="UPDATE `users` SET `verify_code`='$verifyCode' WHERE `user_phone` = '$phone'";
        // $query_update=mysqli_query($con,$sql_update);
        return json_encode(['status' => 'success', 'code' => $verifyCode, 'response'=>$response]);
    } else {
        
        return error('Failed to send verification code. Try again later.');
    }
}


if (!function_exists('error')) {
    function error($message)
    {
        return json_encode(['status' => 'error', 'message' => $message]);
    }
}


if (!function_exists('error405')) {
    function error405($method)
    {
        return json_encode(['status' => 'error', 'message' => "Method $method not allowed"]);
    }
}
