<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

require "../../connect.php";
require "../../lang.php";

$lang = get_current_language();

if ($requestMethod == "POST") {
    $res = updateAddress();
    echo $res;
} else {
    echo error405($requestMethod);
}

function updateAddress()
{

    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);

    global $con;
    global $lang; 
    
    if(!isset($obj['address_id'])){
        return error(trans()["address_id_required"][$lang]);
    }
    if(!isset($obj['user_id'])){
        return error(trans()["user_id_required"][$lang]);
    }
    if(!isset($obj['name'])){
        return error(trans()["address_name_required"][$lang]);
    }
    if(!isset($obj['address'])){
        return error(trans()["address_details_required"][$lang]);
    }
    if(!isset($obj['lat'])){
        return error(trans()["latitude_required"][$lang]);
    }
    if(!isset($obj['lang'])){
        return error(trans()["longitude_required"][$lang]);
    }
    if(!isset($obj['marker'])){
        return error(trans()["marker_required"][$lang]);
    }
    if(!isset($obj['street'])){
        return error(trans()["street_required"][$lang]);
    }
    if(!isset($obj['building_number'])){
        return error(trans()["building_number_required"][$lang]);
    }
    if(!isset($obj['gover'])){
        return error(trans()["governorate_required"][$lang]);
    }
    $address_id = mysqli_real_escape_string($con, $obj['address_id']);
    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    $name = mysqli_real_escape_string($con, $obj['name']);
    $address = mysqli_real_escape_string($con, $obj['address']);
    $lat = mysqli_real_escape_string($con, $obj['lat']);
    $lang = mysqli_real_escape_string($con, $obj['lang']);
    $marker = mysqli_real_escape_string($con, $obj['marker']);
    $street = mysqli_real_escape_string($con, $obj['street']);
    $building_number = mysqli_real_escape_string($con, $obj['building_number']);
    $gover = mysqli_real_escape_string($con, $obj['gover']);


    if (empty(trim($obj['address_id']))) {
        return error(trans()["address_id_required"][$lang]);
    }
    if (empty(trim($obj['user_id']))) {
        return error(trans()["user_id_required"][$lang]);
    }
    if (empty(trim($obj['name']))) {
        return error(trans()["address_name_required"][$lang]);
    }
    if (empty(trim($obj['address']))) {
        return error(trans()["address_details_required"][$lang]);
    }
    if (empty(trim($obj['lat']))) {
        return error(trans()["latitude_required"][$lang]);
    }
    if (empty(trim($obj['lang']))) {
        return error(trans()["longitude_required"][$lang]);
    }
    if (empty(trim($obj['marker']))) {
        return error(trans()["marker_required"][$lang]);
    }
    if (empty(trim($obj['street']))) {
        return error(trans()["street_required"][$lang]);
    }
    if (empty(trim($obj['building_number']))) {
        return error(trans()["building_number_required"][$lang]);
    }
    if (empty(trim($obj['gover']))) {
        return error(trans()["governorate_required"][$lang]);
    }
    
    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$user_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error(trans()["user_not_found_or_banned"][$lang]);
    }
    
    $row_data = mysqli_fetch_object($sql_select);

    if($row_data->user_ban == 1){
        return error(trans()["user_not_found_or_banned"][$lang]);
    }

    $sql_select = mysqli_query($con, "UPDATE `addresses` SET `name`='$name',`address`='$address',`marker`='$marker',`lat`='$lat',`lang`='$lang',`street`='$street',`building_number`='$building_number',`gover`='$gover' WHERE `address_id` = '$address_id'");
    if ($sql_select) {
        return success(trans()["address_updated_successfully"][$lang]);
    } else {
        return serverError();
    }
}
