<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

require "../../connect.php";
require "../../lang.php";

$lang = get_current_language();

if ($requestMethod == "POST") {
    $res = deleteAddress();
    echo $res;
} else {
    echo error405($requestMethod);
}

function deleteAddress()
{
    
    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);
    
    global $con;
    global $lang;
    
    if(!isset($obj['user_id'])){
        return error(trans()["user_id_required"][$lang]);
    }
    if(!isset($obj['address_id'])){
        return error(trans()["address_id_required"][$lang]);
    }
    
    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    $address_id = mysqli_real_escape_string($con, $obj['address_id']);
    
    if (empty(trim($obj['user_id']))) {
        return error(trans()["user_id_required"][$lang]);
    }
    if (empty(trim($obj['address_id']))) {
        return error(trans()["address_id_required"][$lang]);
    }
    
    $sql_select = mysqli_query($con, "SELECT * FROM `users` WHERE `user_id` = '$user_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error(trans()["user_not_found_or_banned"][$lang]);
    }
    
    $row_data = mysqli_fetch_object($sql_select);

    if($row_data->ban == 1){
        return error(trans()["user_not_found_or_banned"][$lang]);
    }
    
    
    $sql_select = mysqli_query($con, "SELECT * FROM `addresses` WHERE `address_id` = '$address_id' AND `user_id` = '$user_id' ");
    if ($sql_select && mysqli_num_rows($sql_select) < 1) {
        return error(trans()["address_not_found"][$lang]);
    }
    
    $sql_select = mysqli_query($con, "DELETE FROM `addresses` WHERE `address_id` = '$address_id' AND `user_id` = '$user_id'");
    if ($sql_select) {
        return success(trans()["address_deleted_successfully"][$lang]);
    } else {
        return serverError();
    }
}