<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
require_once '../../vendor/autoload.php';

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function exportToken($data) {
    $jwtExpiry = 3600 * 72 * 8;
    $jwtSecret = 'Arazon_Secret_Token';

    $now = time();
    $payload = [
        'exp' => $now + $jwtExpiry,
        'data' => $data
    ];

    return JWT::encode($payload, $jwtSecret, 'HS256');
}

function validateToken($token) {
    $jwtSecret = 'Arazon_Secret_Token';
    try {
        return JWT::decode($token, new Key($jwtSecret, 'HS256'));
    } catch (Exception $e) {
        http_response_code(401);
        echo json_encode(['error' => 'Invalid token', 'details' => $e->getMessage()]);
        exit;
    }
}

function getAuthorizedUser() {
    $headers = getallheaders();
    
    if (!isset($headers['Authorization'])) {
        http_response_code(401);
        echo json_encode(['message' => 'Authorization Header Missing']);
        exit;
    }

    $authHeader = $headers['Authorization'];
    list($type, $token) = explode(" ", $authHeader, 2);

    if (strcasecmp($type, 'Bearer') !== 0 || !$token) {
        http_response_code(401);
        echo json_encode(['message' => 'Invalid Authorization Header']);
        exit;
    }

    $decoded = validateToken($token);

    if (!$decoded || !isset($decoded->data)) {
        http_response_code(401);
        echo json_encode(['message' => 'Invalid or Expired Token']);
        exit;
    }

    return $decoded->data;
}

