<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();


if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit(json_encode(['message' => 'Method Not Allowed']));
}


$page     = isset($_GET['page'])     ? max(1, (int)$_GET['page'])             : 1;
$per_page = isset($_GET['per_page']) ? min(100, max(1, (int)$_GET['per_page'])) : 10;
$offset   = ($page - 1) * $per_page;


$countSql = "SELECT COUNT(*) AS total FROM `users`";
$countRes = $con->query($countSql);
if (!$countRes) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Count query failed',
        'details' => $con->error,
    ], JSON_UNESCAPED_UNICODE));
}
$total       = (int)$countRes->fetch_assoc()['total'];
$total_pages = (int)ceil($total / $per_page);


$sql    = "SELECT users.user_id, users.user_name, users.user_email, users.user_phone, users.delivery_address, users.billing_address FROM `users` LIMIT {$offset}, {$per_page}";
$result = $con->query($sql);
if (!$result) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Users query failed',
        'details' => $con->error,
    ], JSON_UNESCAPED_UNICODE));
}


$users = [];
while ($row = $result->fetch_assoc()) {
    $users[] = $row;
}


http_response_code(200);
echo json_encode([
    'data' => $users,
    'meta' => [
        'total'        => $total,
        'per_page'     => $per_page,
        'current_page' => $page,
        'total_pages'  => $total_pages,
        'next_page'    => $page < $total_pages ? "?page=" . ($page + 1) . "&per_page={$per_page}" : null,
        'prev_page'    => $page > 1             ? "?page=" . ($page - 1) . "&per_page={$per_page}" : null,
    ],
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

$con->close();
