<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    exit(json_encode(['message' => 'Method Not Allowed']));
}


$page     = isset($_GET['page'])     ? max(1, (int)$_GET['page'])             : 1;
$per_page = isset($_GET['per_page']) ? min(100, max(1, (int)$_GET['per_page'])) : 10;
$offset   = ($page - 1) * $per_page;


$countSql = "SELECT COUNT(*) AS total FROM reports";
$countRes = $con->query($countSql);
if (!$countRes) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Count query failed',
        'details' => $con->error,
    ], JSON_UNESCAPED_UNICODE));
}
$total       = (int)$countRes->fetch_assoc()['total'];
$total_pages = (int)ceil($total / $per_page);


$sql = "
  SELECT 
    reports.*,
    users.*,
    report_options.*,
    report_sub_options.*,
    JSON_OBJECT(
      'product_title',     products.product_name,
      'product_title_en',  products.product_name_en,
      'product_id',        products.product_id,
      'main_image',        products.product_image
    ) AS product_data
  FROM reports
  LEFT JOIN products            ON products.product_id       = reports.product_id
  LEFT JOIN users               ON users.user_id             = reports.user_id
  LEFT JOIN report_options      ON report_options.option_id  = reports.option_id
  LEFT JOIN report_sub_options  ON report_sub_options.sub_id = reports.sub_option_id
  LIMIT {$offset}, {$per_page}
";
$result = $con->query($sql);
if (!$result) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Reports query failed',
        'details' => $con->error,
    ], JSON_UNESCAPED_UNICODE));
}


$reports = [];
while ($row = $result->fetch_assoc()) {
    $row['product_data'] = json_decode($row['product_data'], true);
    unset($row['user_password']);
    $reports[] = $row;
}


$message = empty($reports)
    ? 'No Reports Found'
    : 'Reports Fetched Successfully';

http_response_code(200);
echo json_encode([
    'message' => $message,
    'data'    => $reports,
    'meta'    => [
        'total'         => $total,
        'per_page'      => $per_page,
        'current_page'  => $page,
        'total_pages'   => $total_pages,
        'next_page'     => $page < $total_pages ? "?page=".($page+1)."&per_page={$per_page}" : null,
        'prev_page'     => $page > 1           ? "?page=".($page-1)."&per_page={$per_page}" : null,
    ],
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

$con->close();
