<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json; charset=utf-8');
$user = getAuthorizedUser();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    exit(json_encode("Method Not Allowed"));
}

// Get the last product_id in the table
$result = $con->query("SELECT MAX(product_id) AS last_id FROM products");
if (!$result) {
    http_response_code(500);
    exit(json_encode([
        'error' => 'Failed to fetch last product ID',
        'details' => $con->error
    ], JSON_UNESCAPED_UNICODE));
}

$row = $result->fetch_assoc();
$lastId = isset($row['last_id']) ? (int)$row['last_id'] : 0;
$nextId = $lastId + 1;

// Set AUTO_INCREMENT to next ID
if (!$con->query("ALTER TABLE products AUTO_INCREMENT = $nextId")) {
    http_response_code(500);
    exit(json_encode([
        'error' => 'Failed to update AUTO_INCREMENT',
        'details' => $con->error
    ], JSON_UNESCAPED_UNICODE));
}

// Respond with confirmation
http_response_code(200);
echo json_encode([
    'last_product_id' => $lastId,
    'auto_increment_set_to' => $nextId,
    'status' => 'success'
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
