<?php
require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['message' => 'Method Not Allowed']);
    exit;
}

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['package_id'])) {
    http_response_code(400);
    echo json_encode(['message' => 'Required package_id']);
    exit;
}

$package_id = (int)$data['package_id'];

$fieldsMap = [
    'package_text'        => ['package_text',        's'],
    'package_description_en' => ['package_description_en', 's'],
    'package_text_en' => ['package_text_en', 's'],
    'package_description' => ['package_description', 's'],
    'package_price'       => ['package_price',       'd'],
     'hidden'       => ['hidden',       's'],
];

$setClauses = [];
$types      = '';
$values     = [];

foreach ($fieldsMap as $inputKey => [$col, $type]) {
    if (array_key_exists($inputKey, $data)) {
        $setClauses[] = "`$col` = ?";
        $types       .= $type;
        $values[]     = $data[$inputKey];
    }
}

if (empty($setClauses)) {
    http_response_code(400);
    echo json_encode(['message' => 'No fields provided to update']);
    exit;
}

$types   .= 'i';
$values[] = $package_id;

$sql = 'UPDATE `packages` SET ' . implode(', ', $setClauses) . ' WHERE `package_id` = ?';
$stmt = $con->prepare($sql);
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['message' => 'Prepare failed', 'error' => $con->error]);
    exit;
}

$stmt->bind_param($types, ...$values);

if ($stmt->execute()) {
    http_response_code(200);
    echo json_encode(['message' => 'Package updated successfully']);
} else {
    http_response_code(500);
    echo json_encode(['message' => 'Update failed', 'error' => $stmt->error]);
}

$stmt->close();
$con->close();
