<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

$page     = isset($_GET['page'])     ? max(1, (int)$_GET['page'])               : 1;
$per_page = isset($_GET['per_page']) ? min(100, max(1, (int)$_GET['per_page']))  : 10;
$offset   = ($page - 1) * $per_page;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $json = file_get_contents('php://input');
    $obj = json_decode($json, true);

    if (!isset($obj['user_id'])) {
        echo json_encode([
            "status" => 400,
            "message" => "user_id_required"
        ]);
        exit;
    }
    
    $user_id = mysqli_real_escape_string($con, $obj['user_id']);
    
    $stmt = $con->prepare("
        SELECT 
            orders.*,
            users.user_name,
                JSON_OBJECT(
                    'product_id', order_items.product_id,
                    'quantity', order_items.quantity,
                    'product_name', products.product_name,
                    'product_image', products.product_image,
                    'product_price', products.product_price
                ) AS products
        FROM orders
        LEFT JOIN users ON orders.user_id = users.user_id
        LEFT JOIN order_items ON orders.order_id = order_items.order_id
        LEFT JOIN products ON order_items.product_id = products.product_id
        WHERE orders.user_id = ?
        GROUP BY orders.order_id
    ");

    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $orders = [];
    while ($row = $result->fetch_assoc()) {
        if (isset($row['products'])) {
            $row['products'] = json_decode($row['products'], true);
        }
        $orders[] = $row;
    }
    
    echo json_encode([
        "status" => 200,
        "orders" => $orders
    ]);

    
} else {
    echo json_encode([
        "status" => 405,
        "message" => "method_not_allowed"
    ]);
    exit;
}
