<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

$page     = isset($_GET['page'])     ? max(1, (int)$_GET['page'])               : 1;
$per_page = isset($_GET['per_page']) ? min(100, max(1, (int)$_GET['per_page']))  : 10;
$offset   = ($page - 1) * $per_page;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit(json_encode(['message' => 'Method Not Allowed']));
}

$countSql = "SELECT COUNT(DISTINCT order_id) AS total FROM orders";
$countRes = $con->query($countSql);
if (!$countRes) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Count query failed',
        'details' => $con->error,
    ]));
}
$total = (int)$countRes->fetch_assoc()['total'];
$total_pages = (int)ceil($total / $per_page);

$sql = "
  SELECT
    orders.*,
    order_gifts.*,
    SUM(products.product_price) AS total_price,
    JSON_ARRAYAGG(
      JSON_OBJECT(
        'product_id',          products.product_id,
        'product_name',        products.product_name,
        'product_description', products.product_description,
        'category_id',         products.product_catId,
        'product_image',       products.product_image,
        'url',                 products.product_url,
        'product_price',       products.product_price,
        'price_type',          products.price_type,
        'hidden',              products.hidden,
        'seller_id',           products.seller_id,
        'location_id',         products.location_id,
        'package_id',          products.package_id,
        'discount',            products.product_discount,
        'created_at',          products.created_at,
        'images', (
          SELECT JSON_ARRAYAGG(CONCAT('https://api.tiffanyflowers.ae/admin/',pi.url))
          FROM product_images AS pi
          WHERE pi.product_id = products.product_id
        ),
        'reviews', (
          SELECT JSON_ARRAYAGG(
            JSON_OBJECT(
              'review_id', pr.review_id,
              'text',      pr.review_text,
              'reviewer',  JSON_OBJECT(
                             'id',    usr.user_id,
                             'name',  usr.user_name,
                             'image', usr.user_image
                           )
            )
          )
          FROM product_reviews AS pr
          LEFT JOIN users AS usr ON usr.user_id = pr.user_id
          WHERE pr.product_id = products.product_id
        ),
        'seller', (
          SELECT JSON_OBJECT(
            'seller_id',   us.user_id,
            'seller_name', us.user_name,
            'seller_image',us.user_image,
            'seller_email',us.user_email,
            'seller_phone',us.user_phone
          )
          FROM users AS us
          WHERE us.user_id = products.seller_id
        )
      )
    ) AS products,
    JSON_OBJECT(
      'id',    users.user_id,
      'name',  users.user_name,
      'image', users.user_image,
      'email', users.user_email,
      'phone', users.user_phone
    ) AS user,
    order_gifts.*
    
  FROM orders
    LEFT JOIN order_items ON orders.order_id = order_items.order_id
    LEFT JOIN order_gifts ON order_gifts.order_id = orders.order_id
    LEFT JOIN products     ON order_items.product_id = products.product_id
    LEFT JOIN users        ON orders.user_id = users.user_id
  GROUP BY orders.order_id
  ORDER BY orders.order_id DESC
  LIMIT {$offset}, {$per_page}
";

$result = $con->query($sql);
if (!$result) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Orders query failed',
        'details' => $con->error,
    ]));
}

$orders = [];
while ($row = $result->fetch_assoc()) {
    $row['products'] = json_decode($row['products'], true);
    $row['user']     = json_decode($row['user'], true);
    $orders[]        = $row;
}

http_response_code(200);
echo json_encode([
    'data' => $orders,
    'meta' => [
        'total'         => $total,
        'per_page'      => $per_page,
        'current_page'  => $page,
        'total_pages'   => $total_pages,
        'next_page'     => $page < $total_pages ? "?page=".($page+1)."&per_page={$per_page}" : null,
        'prev_page'     => $page > 1             ? "?page=".($page-1)."&per_page={$per_page}" : null,
    ],
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

$con->close();
