<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['message' => 'Method Not Allowed']);
    exit;
}

if (!isset($data['category_id'])) {
    http_response_code(400);
    echo json_encode(['message' => "Required field: category_id"]);
    exit;
}

$category_id = (int)$data['category_id'];

$fields   = [];
$params   = [];
$types    = '';

if (array_key_exists('parent_id', $data)) {
    $fields[]    = 'parent_id = ?';
    $types      .= 'i';
    $params[]    = $data['parent_id'];
}

if (array_key_exists('category_name', $data)) {
    $fields[]    = 'cat_name = ?';
    $types      .= 's';
    $params[]    = $data['category_name'];
}

if (array_key_exists('category_name_en', $data)) {
    $fields[]    = 'cat_name_en = ?';
    $types      .= 's';
    $params[]    = $data['category_name_en'];
}

if (array_key_exists('category_image', $data)) {
    $fields[]    = 'cat_image = ?';
    $types      .= 's';
    $params[]    = $data['category_image'];
}

if (array_key_exists('category_status', $data)) {
    $fields[]    = 'hidden = ?';
    $types      .= 's';
    $params[]    = $data['category_status'];
}

if (empty($fields)) {
    http_response_code(400);
    echo json_encode(['message' => 'No fields provided to update']);
    exit;
}

$sql = "UPDATE categories SET " . implode(', ', $fields) . " WHERE cat_id = ?";
$types  .= 'i';
$params[] = $category_id;

$stmt = $con->prepare($sql);
$stmt->bind_param($types, ...$params);

if ($stmt->execute()) {
    http_response_code(200);
    echo json_encode(['message' => 'Category updated successfully']);
} else {
    http_response_code(500);
    echo json_encode(['message' => 'Failed to update category']);
}

$stmt->close();
$con->close();
