<?php
require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json; charset=utf-8');
$user = getAuthorizedUser();


$page     = isset($_GET['page'])     ? max(1, (int)$_GET['page'])             : 1;
$per_page = isset($_GET['per_page']) ? min(100, max(1, (int)$_GET['per_page'])) : 10;


$sql    = "SELECT * FROM categories";
$result = mysqli_query($con, $sql);
if (!$result) {
    http_response_code(500);
    exit(json_encode([
        'error'   => 'Database query failed',
        'details' => mysqli_error($con)
    ], JSON_UNESCAPED_UNICODE));
}

$all = [];
while ($row = mysqli_fetch_assoc($result)) {
    $row['cat_id']    = (int)$row['cat_id'];
    $row['parent_id'] = (int)$row['parent_id'];
    $all[] = $row;
}


function buildTree(array $elements, int $parentId = 0): array {
    $branch = [];
    foreach ($elements as $el) {
        if ($el['parent_id'] === $parentId) {
            $children = buildTree($elements, $el['cat_id']);
            $branch[] = [
                'category_id'     => $el['cat_id'],
                'parent_id'     => $el['parent_id'],
                'category_name'   => $el['cat_name'],
                'category_name_en'   => $el['cat_name_en'],
                'category_image'  => $el['cat_image'],
                'category_status' => $el['hidden'],
                'sub_categories'  => $children
            ];
        }
    }
    return $branch;
}

$tree = buildTree($all, 0);


$total        = count($tree);
$total_pages  = (int)ceil($total / $per_page);
$offset       = ($page - 1) * $per_page;
$paginated    = array_slice($tree, $offset, $per_page);


http_response_code(200);
echo json_encode([
    'data' => $paginated,
    'meta' => [
        'total'        => $total,
        'per_page'     => $per_page,
        'current_page' => $page,
        'total_pages'  => $total_pages,
        'next_page'    => $page < $total_pages ? "?page=" . ($page + 1) . "&per_page={$per_page}" : null,
        'prev_page'    => $page > 1             ? "?page=" . ($page - 1) . "&per_page={$per_page}" : null,
    ],
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
