
<?php

require "../../connect.php";
require "../../helpers/jwt.php";

header('Content-Type: application/json');
$user = getAuthorizedUser();

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    foreach (['category_name'] as $field) {
        if (!isset($data[$field])) {
            http_response_code(400);
            echo json_encode(['message' => "Required $field"]);
            exit;
        }
    }
    $parent_id = 0;
    if(isset($data['parent_id'])){
    $parent_id = $data['parent_id'];
   }
   $name = $data['category_name'];
   $name_en = isset($data['category_name_en']) ?? '';
    
    $default_image = 'https://camp-coding.site/arazon/images/arazon(1).png';
    $image = !empty($data['category_image']) ? $data['category_image'] : $default_image;
    
    $insert = $con->prepare("INSERT INTO categories (parent_id, cat_name, cat_name_en, cat_image) VALUES (?, ?, ?, ?)");
    $insert->bind_param("isss", $parent_id, $name, $name_en, $image);

    if ($insert->execute()) {
        http_response_code(201);
        echo json_encode(['message' => 'Category created successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['message' => 'Failed to create category']);
    }

    $insert->close();
    $con->close();

} else {
    http_response_code(405);
    echo json_encode(['message' => 'Method Not Allowed']);
}
