<?php

require "../../connect.php";
require "../../helpers/jwt.php";

$input = file_get_contents("php://input");
$json = json_decode($input, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    foreach (['admin_email', 'admin_password'] as $data) {
        if (empty($json[$data])) {
            http_response_code(400);
            echo json_encode(['message' => "$data Required"]);
            exit;
        }
    }

    $email    = trim($json['admin_email']);
    $password = $json['admin_password'];

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode(['message' => 'Invalid Email']);
        exit;
    }

    $stmt = $con->prepare('SELECT * FROM admins WHERE admin_email = ?');
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
        http_response_code(403);
        echo json_encode(['message' => 'You Are Not Allowed']);
        exit;
    }

    $admin = $result->fetch_assoc();

    // echo json_encode($admin);
    
    if ($password !== $admin['admin_password']) {
        http_response_code(403);
        echo json_encode(['message' => 'Invalid Credentials']);
        exit;
    }

    $payload = [
        'admin_id' => $admin['admin_id'],
        'email'    => $admin['admin_email'],
    ];
    
    $token = exportToken($payload);
    // echo $token;
    unset($admin['admin_password']);

    http_response_code(200);
    echo json_encode([
        'message' => 'Logged in successfully',
        'token'   => $token,
        'data'    => $admin
    ]);
    exit;

} else {
    http_response_code(405);
    echo json_encode(['message' => 'Method Not Allowed']);
}


