<?php

require "../../connect.php";
require "../../helpers/jwt.php";

$input = file_get_contents("php://input");
$json = json_decode($input, true);

$user = getAuthorizedUser();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    foreach (['admin_name', 'admin_phone', 'admin_email', 'admin_password'] as $data) {
        if (empty($json[$data])) {
            http_response_code(422);
            echo json_encode(['message' => "$data is required"]);
            exit;
        }
    }

    $name = $json['admin_name'];
    $phone = $json['admin_phone'];
    $email = trim($json['admin_email']);
    $password = $json['admin_password'];

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo json_encode(['message' => 'Invalid email']);
        exit;
    }

    if (strlen($password) < 8) {
        http_response_code(422);
        echo json_encode(['message' => 'Password must be at least 8 characters']);
        exit;
    }

    $stmt = $con->prepare("SELECT admin_id FROM admins WHERE admin_email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        http_response_code(409);
        echo json_encode(['message' => 'Admin already exists']);
        exit;
    }
    $stmt->close();


    $insert = $con->prepare("INSERT INTO admins (admin_name, admin_phone, admin_email, admin_password) VALUES (?, ?, ?, ?)");
    $insert->bind_param("ssss", $name, $phone, $email, $password);

    if ($insert->execute()) {
        http_response_code(201);
        echo json_encode(['message' => 'Admin created successfully']);
    } else {
        http_response_code(500);
        echo json_encode(['message' => 'Failed to create admin']);
    }

    $insert->close();
    $con->close();

} else {
    http_response_code(405);
    echo json_encode(['message' => 'Method Not Allowed']);
    exit;
}
